/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.configuration.InputActivationConfiguration;
import net.labymod.addons.voicechat.api.configuration.RealisticAmbientSoundConfiguration;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.core.configuration.DefaultInputActivationConfiguration;
import net.labymod.addons.voicechat.core.configuration.DefaultRealisticAmbientSoundConfiguration;
import net.labymod.addons.voicechat.core.ui.config.activation.SensitivityWidget;
import net.labymod.addons.voicechat.core.ui.config.device.DeviceConfiguratorWidget;
import net.labymod.api.addon.AddonConfig;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.widget.widgets.input.KeybindWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.configuration.loader.annotation.ConfigName;
import net.labymod.api.configuration.loader.annotation.Exclude;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.annotation.SpriteTexture;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.configuration.settings.annotation.SettingDevelopment;
import net.labymod.api.configuration.settings.annotation.SettingRequires;
import net.labymod.api.configuration.settings.annotation.SettingSection;
import net.labymod.api.models.OperatingSystem;

@SpriteTexture(value="settings")
@ConfigName(value="settings")
public class DefaultVoiceChatConfiguration
extends AddonConfig
implements VoiceChatConfiguration {
    @SpriteSlot
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> enabled = new ConfigProperty((Object)true);
    @SettingSection(value="general")
    @SpriteSlot(x=4, y=3)
    private DefaultInputActivationConfiguration inputActivation = new DefaultInputActivationConfiguration();
    @SpriteSlot(x=5)
    @SensitivityWidget.SensitivitySetting
    private ConfigProperty<Double> voiceActivationSensitivity = new ConfigProperty((Object)-50.0);
    @SpriteSlot(x=3)
    @DeviceConfiguratorWidget.DeviceConfiguratorSetting(type=DeviceType.INPUT, volumeSliderSetting=@SliderWidget.SliderSetting(min=0.0f, max=2.0f, steps=0.05f), volumePropertyName="inputVolume")
    private ConfigProperty<String> inputDeviceName = new ConfigProperty((Object)"");
    private ConfigProperty<Float> inputVolume = new ConfigProperty((Object)Float.valueOf(1.0f));
    @SpriteSlot(x=4)
    @DeviceConfiguratorWidget.DeviceConfiguratorSetting(type=DeviceType.OUTPUT, volumeSliderSetting=@SliderWidget.SliderSetting(min=0.0f, max=2.0f, steps=0.05f), volumePropertyName="outputVolume")
    private ConfigProperty<String> outputDeviceName = new ConfigProperty((Object)"");
    private ConfigProperty<Float> outputVolume = new ConfigProperty((Object)Float.valueOf(1.0f));
    @SettingSection(value="keybinding")
    @SpriteSlot(x=2)
    @KeybindWidget.KeyBindSetting(acceptMouseButtons=true)
    private ConfigProperty<Key> pushToTalkKey = new ConfigProperty((Object)Key.F);
    @SpriteSlot(x=3, y=2)
    @KeybindWidget.KeyBindSetting(acceptMouseButtons=true)
    private ConfigProperty<Key> toggleMuteInputKey = new ConfigProperty((Object)Key.M);
    @SpriteSlot(x=3, y=3)
    @KeybindWidget.KeyBindSetting(acceptMouseButtons=true)
    private ConfigProperty<Key> toggleMuteOutputKey = new ConfigProperty((Object)Key.NONE);
    @SpriteSlot(x=7, y=1)
    @KeybindWidget.KeyBindSetting(acceptMouseButtons=true)
    private ConfigProperty<Key> voiceChannelsKey = new ConfigProperty((Object)Key.V);
    @SettingSection(value="sound")
    @SpriteSlot(y=1)
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> stereo = new ConfigProperty((Object)true);
    @SpriteSlot(x=1, y=1)
    @SliderWidget.SliderSetting(min=8.0f, max=32.0f)
    private ConfigProperty<Integer> surroundRange = new ConfigProperty((Object)24);
    @SpriteSlot(x=1)
    private DefaultRealisticAmbientSoundConfiguration realisticAmbientSound = new DefaultRealisticAmbientSoundConfiguration();
    @SpriteSlot(x=2, y=1)
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> volumeCompressor = new ConfigProperty((Object)true);
    @SpriteSlot(x=0, y=2)
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> noiseSuppression = new ConfigProperty((Object)true);
    @SettingSection(value="misc")
    @SpriteSlot(x=4)
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> tabListIndicator = new ConfigProperty((Object)false);
    @SpriteSlot(x=0, y=3)
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> channelIndicatorBelowName = new ConfigProperty((Object)true);
    @SpriteSlot(x=3, y=1)
    @SliderWidget.SliderSetting(min=0.0f, max=2.0f, steps=0.05f)
    private ConfigProperty<Float> focusedVolume = new ConfigProperty((Object)Float.valueOf(1.2f));
    @SpriteSlot(x=4, y=1)
    @SliderWidget.SliderSetting(min=0.0f, max=2.0f, steps=0.05f)
    private ConfigProperty<Float> unfocusedVolume = new ConfigProperty((Object)Float.valueOf(0.2f));
    @SpriteSlot(x=5, y=1)
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> useBackupServer = new ConfigProperty((Object)false);
    @SettingDevelopment
    @SpriteSlot(x=6, y=1)
    @SettingRequires(value="useBackupServer", invert=true)
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> useTestServer = new ConfigProperty((Object)false);
    @SpriteSlot(x=7, y=2)
    @SwitchWidget.SwitchSetting
    private ConfigProperty<Boolean> alternativeAudioInterfaces = new ConfigProperty((Object)OperatingSystem.isOSX());
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> modView = new ConfigProperty((Object)true);
    @Exclude
    private ConfigProperty<Long> timeRulesAccepted = new ConfigProperty((Object)-1L);
    @Exclude
    private ConfigProperty<Map<UUID, Float>> playerVolumes = new ConfigProperty(new HashMap());
    @Exclude
    private ConfigProperty<Long> tutorialHintMask = new ConfigProperty((Object)0L);

    @Override
    public ConfigProperty<Boolean> enabled() {
        return this.enabled;
    }

    @Override
    public ConfigProperty<Key> pushToTalkKey() {
        return this.pushToTalkKey;
    }

    @Override
    public ConfigProperty<Key> toggleMuteInputKey() {
        return this.toggleMuteInputKey;
    }

    @Override
    public ConfigProperty<Key> toggleMuteOutputKey() {
        return this.toggleMuteOutputKey;
    }

    @Override
    public ConfigProperty<Key> voiceChannelsKey() {
        return this.voiceChannelsKey;
    }

    @Override
    public InputActivationConfiguration inputActivation() {
        return this.inputActivation;
    }

    @Override
    public ConfigProperty<Double> voiceActivationSensitivity() {
        return this.voiceActivationSensitivity;
    }

    @Override
    public ConfigProperty<Float> inputVolume() {
        return this.inputVolume;
    }

    @Override
    public ConfigProperty<Float> outputVolume() {
        return this.outputVolume;
    }

    @Override
    public ConfigProperty<String> inputDeviceName() {
        return this.inputDeviceName;
    }

    @Override
    public ConfigProperty<String> outputDeviceName() {
        return this.outputDeviceName;
    }

    @Override
    public ConfigProperty<Boolean> stereo() {
        return this.stereo;
    }

    @Override
    public ConfigProperty<Integer> surroundRange() {
        return this.surroundRange;
    }

    @Override
    public RealisticAmbientSoundConfiguration realisticAmbientSound() {
        return this.realisticAmbientSound;
    }

    @Override
    public ConfigProperty<Boolean> volumeCompressor() {
        return this.volumeCompressor;
    }

    @Override
    public ConfigProperty<Boolean> noiseSuppression() {
        return this.noiseSuppression;
    }

    @Override
    public ConfigProperty<Boolean> tabListIndicator() {
        return this.tabListIndicator;
    }

    @Override
    public ConfigProperty<Boolean> channelIndicatorBelowName() {
        return this.channelIndicatorBelowName;
    }

    @Override
    public ConfigProperty<Float> focusVolumeIncrease() {
        return this.focusedVolume;
    }

    @Override
    public ConfigProperty<Float> focusVolumeDecrease() {
        return this.unfocusedVolume;
    }

    @Override
    public ConfigProperty<Boolean> useBackupServer() {
        return this.useBackupServer;
    }

    @Override
    public ConfigProperty<Boolean> useTestServer() {
        return this.useTestServer;
    }

    @Override
    public ConfigProperty<Map<UUID, Float>> playerVolumes() {
        return this.playerVolumes;
    }

    @Override
    public ConfigProperty<Boolean> alternativeAudioInterfaces() {
        return this.alternativeAudioInterfaces;
    }

    public ConfigProperty<Long> timeRulesAccepted() {
        return this.timeRulesAccepted;
    }

    public ConfigProperty<Long> tutorialHintMask() {
        return this.tutorialHintMask;
    }

    @Override
    public ConfigProperty<Boolean> modView() {
        return this.modView;
    }

    @Override
    public float getVolumeOf(UUID uniqueId) {
        return ((Map)this.playerVolumes.get()).getOrDefault(uniqueId, Float.valueOf(1.0f)).floatValue();
    }

    public boolean hasCompletedTutorial(int id) {
        return ((Long)this.tutorialHintMask.get() & 1L << id) != 0L;
    }

    public void setTutorialCompleted(int id) {
        this.tutorialHintMask.set((Object)((Long)this.tutorialHintMask.get() | 1L << id));
    }

    public int getConfigVersion() {
        return 2;
    }
}

