/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.listener;

import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.api.event.Phase;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameTickEvent;
import net.labymod.api.util.time.TimeUtil;

public class TickListener {
    private static final long RECONNECT_DURATION = 4000L;
    private final AudioStreamRegistry audioStreamRegistry;
    private final VoiceConnector client;
    private final VoiceChatConfiguration config;
    private long nextConnectTime;

    public TickListener(DefaultReferenceStorage references) {
        this.audioStreamRegistry = references.audioStreamRegistry();
        this.client = references.voiceConnector();
        this.config = references.voiceChat().configuration();
    }

    @Subscribe
    public void onGameTick(GameTickEvent event) {
        if (event.phase() != Phase.POST) {
            return;
        }
        if (this.client.isConnected()) {
            this.nextConnectTime = TimeUtil.getCurrentTimeMillis() + 4000L;
        } else {
            long duration = this.getReconnectDuration();
            if (duration < 0L) {
                this.nextConnectTime = TimeUtil.getCurrentTimeMillis() + 4000L;
                this.client.connect();
            }
        }
        this.audioStreamRegistry.tick();
    }

    public long getReconnectDuration() {
        return this.nextConnectTime - TimeUtil.getCurrentTimeMillis();
    }
}

