/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal;

import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.exception.DeviceException;
import net.labymod.addons.voicechat.api.audio.device.io.AbstractDevice;
import net.labymod.addons.voicechat.api.audio.device.io.InputDevice;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import net.labymod.addons.voicechat.openal.api.ALCapture;
import org.jetbrains.annotations.NotNull;

public class OpenALInputDevice
extends AbstractDevice
implements InputDevice {
    private ALCapture microphone;
    private float[] buffer;

    public OpenALInputDevice(@NotNull DeviceInformation information) {
        super(information);
    }

    @Override
    public void open(Format format, int bufferSize) throws DeviceException {
        if (this.isOpen()) {
            throw new DeviceException(this, "Device is already open");
        }
        this.microphone = new ALCapture();
        String deviceId = this.information.getIdentifier().getDeviceId();
        boolean success = this.microphone.open(deviceId, format, bufferSize);
        if (!success) {
            this.logging.error((CharSequence)("Failed to find target device " + String.valueOf(this.information.getIdentifier()) + ", using default"), new Object[0]);
            success = this.microphone.open(ALCapture.getDefaultName(), format, bufferSize);
            if (!success) {
                throw new DeviceException(this, "Couldn't find any device with the specified format: " + String.valueOf(format));
            }
        }
        super.open(format, bufferSize);
    }

    @Override
    public void start() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device is not open");
        }
        this.microphone.start();
    }

    @Override
    public void stop() {
        if (!this.isOpen()) {
            return;
        }
        this.microphone.stop();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.stop();
        this.microphone.close();
        super.close();
    }

    @Override
    public boolean isOpen() {
        return this.microphone != null && this.microphone.isOpen();
    }

    @Override
    public boolean isActive() {
        return this.microphone != null && this.microphone.isActive();
    }

    @Override
    public int available() {
        if (!this.isOpen()) {
            return 0;
        }
        return this.microphone.available();
    }

    @Override
    public void read(short[] out, int offset, int length) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device is not open");
        }
        int available = this.available();
        if (available < length) {
            throw new IllegalStateException("Not enough samples available: Available: " + available + ", requested: " + length);
        }
        if (this.buffer == null || this.buffer.length < length) {
            this.buffer = new float[length];
        }
        this.microphone.read(this.buffer, length);
        for (int i = 0; i < length; ++i) {
            out[offset + i] = (short)(this.buffer[i] * 32767.0f);
        }
    }

    @Override
    public long getProcessIntervalMs() {
        return 5L;
    }
}

