/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.audio.device;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.labymod.addons.voicechat.api.audio.device.AudioInterface;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.device.util.Format;

public abstract class AbstractAudioInterface
implements AudioInterface {
    private final List<DeviceInformation> inputDevices = new ArrayList<DeviceInformation>();
    private final List<DeviceInformation> outputDevices = new ArrayList<DeviceInformation>();

    protected abstract Collection<DeviceInformation> fetchAvailableDevices(DeviceType var1, Format var2);

    @Override
    public void fetchInputDevices(Format format) {
        Collection<DeviceInformation> devices = this.fetchAvailableDevices(DeviceType.INPUT, format);
        for (DeviceInformation device : devices) {
            if (this.inputDevices.contains(device)) continue;
            this.inputDevices.add(device);
        }
    }

    @Override
    public void fetchOutputDevices(Format format) {
        Collection<DeviceInformation> devices = this.fetchAvailableDevices(DeviceType.OUTPUT, format);
        for (DeviceInformation device : devices) {
            if (this.outputDevices.contains(device)) continue;
            this.outputDevices.add(device);
        }
    }

    @Override
    public void clearInputDevices() {
        this.inputDevices.clear();
    }

    @Override
    public void clearOutputDevices() {
        this.outputDevices.clear();
    }

    @Override
    public Collection<DeviceInformation> getInputDevices() {
        return this.inputDevices;
    }

    @Override
    public Collection<DeviceInformation> getOutputDevices() {
        return this.outputDevices;
    }
}

