/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.audio.device.util;

import java.util.Objects;
import net.labymod.addons.voicechat.api.audio.device.util.ChannelType;

public class Format {
    private final int sampleRate;
    private final ChannelType channelType;

    private Format(int sampleRate, ChannelType channelType) {
        this.sampleRate = sampleRate;
        this.channelType = channelType;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public int getChannels() {
        return this.channelType.getChannels();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Format format = (Format)o;
        return this.sampleRate == format.sampleRate && this.channelType == format.channelType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sampleRate, this.channelType});
    }

    public int getBufferSizeForMs(int ms) {
        return this.sampleRate / 1000 * this.channelType.getChannels() * 2 * ms;
    }

    public static class Builder {
        private int sampleRate = 48000;
        private ChannelType channelType = ChannelType.MONO;

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder channels(ChannelType channelType) {
            this.channelType = channelType;
            return this;
        }

        public Format build() {
            return new Format(this.sampleRate, this.channelType);
        }
    }
}

