/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.audio.util;

import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.time.TimeUtil;

public class VisualBuffer {
    private float[] buffer = new float[0];
    private boolean odd;
    private long lastChanged;

    public void write(short[] samples) {
        int length = samples.length;
        if (this.buffer.length != length * 2) {
            this.buffer = new float[length * 2];
        }
        if (length == 0) {
            return;
        }
        int offset = this.odd ? length : 0;
        float max = 0.0f;
        for (int index = 0; index < length; index += 2) {
            short sample = samples[index];
            this.buffer[index / 2 + offset] = (float)sample / 32768.0f;
            sample = sample < 0 ? (short)(-sample) : sample;
            max = (float)sample > max ? (float)sample : max;
        }
        float volume = 2000.0f / max;
        if (volume < 1.0f) {
            for (int index = 0; index < length; ++index) {
                int n = index + offset;
                this.buffer[n] = this.buffer[n] * volume;
            }
        }
        boolean bl = this.odd = !this.odd;
        if (this.odd) {
            this.lastChanged = TimeUtil.getCurrentTimeMillis();
        }
    }

    public void render(ScreenContext context, float x, float y, float width) {
        float[] buffer = this.buffer;
        int length = buffer.length;
        if (length == 0) {
            return;
        }
        long passed = TimeUtil.getCurrentTimeMillis() - this.lastChanged;
        int start = (int)(passed * (long)(length / 2 / 500) % (long)length);
        this.renderWave(context, buffer, length, x, y, width, start, length / 4);
    }

    private void renderWave(ScreenContext context, float[] buffer, int bufferLength, float x, float y, float width, int offset, int length) {
        int steps = length / 100;
        ScreenCanvas canvas = context.canvas();
        for (int index = 0; index < length; index += steps) {
            int bufferIndex = offset + index;
            if (bufferIndex >= bufferLength - steps) {
                bufferIndex -= bufferLength - steps;
            }
            float previousValue = buffer[MathHelper.clamp((int)bufferIndex, (int)0, (int)(bufferLength - 1))];
            float value = buffer[MathHelper.clamp((int)(bufferIndex + 1), (int)0, (int)(bufferLength - 1))];
            float previousPosX = x + (float)index / (float)length * width;
            float posX = x + (float)(index + steps) / (float)length * width;
            float previousPosY = y + previousValue * 40.0f;
            float posY = y + value * 40.0f;
            canvas.submitLine(previousPosX, previousPosY, posX, posY, -1);
        }
    }
}

