/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user;

import java.util.UUID;
import net.labymod.addons.voicechat.api.audio.opus.OpusFactory;
import net.labymod.addons.voicechat.api.audio.stream.user.UserAudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.player.effect.AudioPostProcessor;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.core.audio.stream.user.AbstractAudioStream;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.UserAudioPostProcessor;
import net.labymod.api.Laby;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.world.ClientWorld;
import org.jetbrains.annotations.NotNull;

public class DefaultUserAudioStream
extends AbstractAudioStream
implements UserAudioStream {
    protected final VoiceUser voiceUser;

    public DefaultUserAudioStream(@NotNull VoiceUser user, @NotNull OpusFactory opus) {
        super(user.getUniqueId(), opus);
        this.voiceUser = user;
    }

    @Override
    protected AudioPostProcessor createAudioPostProcessor() {
        return new UserAudioPostProcessor(this.voiceUser);
    }

    @Override
    @NotNull
    public VoiceUser voiceUser() {
        return this.voiceUser;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        ClientWorld world = Laby.labyAPI().minecraft().clientWorld();
        Player player = world.getPlayer(this.id).orElse(null);
        if (player == null) {
            return this.voiceUser.getUniqueId().toString();
        }
        return player.getName();
    }

    @Override
    @NotNull
    public UUID getUserId() {
        return this.id;
    }
}

