/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect;

import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.configuration.RealisticAmbientSoundConfiguration;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.UserAudioPostProcessor;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter.LowPassAudioFilter;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter.ReverbAudioFilter;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.api.Laby;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.world.ClientWorld;
import net.labymod.api.client.world.MinecraftCamera;
import net.labymod.api.client.world.block.BlockState;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.math.vector.DoubleVector3;

public class AmbientAudioPostProcessor
extends UserAudioPostProcessor {
    private final Player player;
    private final RealisticAmbientSoundConfiguration configuration;
    private final LowPassAudioFilter lowPassAudioFilter;
    private final ReverbAudioFilter reverbAudioFilter;

    public AmbientAudioPostProcessor(Player player, VoiceUser user) {
        super(user);
        this.player = player;
        this.configuration = ((DefaultVoiceChatConfiguration)VoiceChatAddon.INSTANCE.configuration()).realisticAmbientSound();
        this.reverbAudioFilter = new ReverbAudioFilter();
        this.register(this.reverbAudioFilter);
        this.lowPassAudioFilter = new LowPassAudioFilter();
        this.register(this.lowPassAudioFilter);
        this.reverbAudioFilter.setInterval(8000);
        this.reverbAudioFilter.setLoops(15);
        this.lowPassAudioFilter.setAmount(50.0);
    }

    @Override
    public void tick() {
        super.tick();
        boolean enabled = (Boolean)this.configuration.enabled().get();
        DoubleVector3 position = this.player.position().toDoubleVector3();
        ClientWorld world = Laby.labyAPI().minecraft().clientWorld();
        if (!enabled || world == null) {
            this.reverbAudioFilter.setOpacity(0.0f);
            this.lowPassAudioFilter.setOpacity(0.0f);
            return;
        }
        int x = (int)Math.floor(position.getX());
        int y = (int)Math.floor(position.getY());
        int z = (int)Math.floor(position.getZ());
        this.updateReverb(world, x, y, z);
        this.updateLowPass(world, x, y, z);
    }

    private void updateReverb(ClientWorld world, int x, int y, int z) {
        boolean echoEnabled = (Boolean)this.configuration.echo().get();
        int maxY = 64;
        if (y >= maxY || !echoEnabled) {
            this.reverbAudioFilter.setOpacity(0.0f, 5000L);
            return;
        }
        MinecraftCamera camera = Laby.labyAPI().minecraft().getCamera();
        if (camera == null) {
            this.reverbAudioFilter.setOpacity(0.0f);
            return;
        }
        DoubleVector3 cameraPosition = camera.position();
        int skyLight = Math.max(world.getPackedLight(cameraPosition) >> 20 & 0xF, world.getPackedLight((float)x, (float)y, (float)z) >> 20 & 0xF);
        if (skyLight != 0 || this.lowPassAudioFilter.getOpacity() > 0.0f) {
            this.reverbAudioFilter.setOpacity(0.0f, 5000L);
            return;
        }
        int solid = 0;
        int space = 0;
        for (int i = y; i < maxY; ++i) {
            BlockState block = world.getBlockState(x, i, z);
            if (block.block().isAir()) {
                if (solid > 0 || space > 32) break;
                ++space;
                continue;
            }
            if (solid >= 10) break;
            ++solid;
        }
        double distance = Math.sqrt(MathHelper.square((double)(cameraPosition.getX() - (double)x)) + MathHelper.square((double)(cameraPosition.getY() - (double)y)) + MathHelper.square((double)(cameraPosition.getZ() - (double)z)));
        float volume = (float)MathHelper.clamp((double)(1.0 - distance / 50.0), (double)0.0, (double)1.0);
        float depth = (float)solid / 10.0f;
        float strength = depth * volume;
        this.reverbAudioFilter.setOpacity(strength, 5000L);
    }

    private void updateLowPass(ClientWorld world, int x, int y, int z) {
        boolean muffleEnabled = (Boolean)this.configuration.muffle().get();
        if (world == null || !muffleEnabled) {
            return;
        }
        MinecraftCamera camera = Laby.labyAPI().minecraft().getCamera();
        if (camera == null) {
            this.lowPassAudioFilter.setOpacity(0.0f);
            return;
        }
        DoubleVector3 cameraPosition = camera.position();
        if (world.getBlockState(x, y + 1, z).isFluid() || world.getBlockState(cameraPosition.copy().add(0.0, 1.0, 0.0)).isFluid()) {
            this.lowPassAudioFilter.setOpacity(1.0f);
            this.reverbAudioFilter.setOpacity(0.0f);
            return;
        }
        int packedLight1 = world.getPackedLight((float)x, (float)y, (float)z);
        int packedLight2 = world.getPackedLight(cameraPosition);
        int skyLight1 = packedLight1 >> 20 & 0xF;
        int skyLight2 = packedLight2 >> 20 & 0xF;
        if (skyLight1 > 10 && skyLight2 > 10) {
            this.lowPassAudioFilter.setOpacity(0.0f);
            return;
        }
        for (int offsetX = -2; offsetX <= 2; offsetX += 2) {
            for (int offsetY = 0; offsetY <= 2; offsetY += 2) {
                for (int offsetZ = -2; offsetZ <= 2; offsetZ += 2) {
                    boolean blockInBetween = this.isBlockInBetween(world, x + offsetX, y + offsetY, z + offsetZ, cameraPosition.getX() + (double)offsetX, cameraPosition.getY() + (double)offsetY, cameraPosition.getZ() + (double)offsetZ);
                    if (blockInBetween) continue;
                    this.lowPassAudioFilter.setOpacity(0.0f, 1000L);
                    return;
                }
            }
        }
        this.lowPassAudioFilter.setOpacity(1.0f, 1000L);
    }

    private boolean isBlockInBetween(ClientWorld world, double fromX, double fromY, double fromZ, double toX, double toY, double toZ) {
        int distance = MathHelper.ceil((double)Math.sqrt(MathHelper.square((double)(toX - fromX)) + MathHelper.square((double)(toY - fromY)) + MathHelper.square((double)(toZ - fromZ))));
        for (int i = 0; i < distance; ++i) {
            double x = fromX + (toX - fromX) * (double)i / (double)distance;
            double y = fromY + (toY - fromY) * (double)i / (double)distance;
            double z = fromZ + (toZ - fromZ) * (double)i / (double)distance;
            if (!world.hasSolidBlockAt(MathHelper.floor((double)x), MathHelper.floor((double)y), MathHelper.floor((double)z))) continue;
            return true;
        }
        return false;
    }
}

