/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter;

import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.OpacityAudioFilter;

public class HighPassAudioFilter
extends OpacityAudioFilter {
    private boolean initialized = false;
    private short lastSample;

    @Override
    public void preProcess(short[] samples, int offset, int length) {
        if (!this.initialized) {
            this.lastSample = 0;
            this.initialized = true;
        }
        double opacity = this.getOpacity();
        for (int i = offset; i < length; ++i) {
            short sample = (short)(samples[i] * 3);
            short diffSample = (short)(sample - this.lastSample);
            samples[i] = (short)((double)sample * (1.0 - opacity) + (double)diffSample * opacity);
            this.lastSample = sample;
        }
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public void reset() {
        this.initialized = false;
        this.lastSample = 0;
    }
}

