/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter;

import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.AbstractAudioFilter;

public class NoiseAudioFilter
extends AbstractAudioFilter {
    private boolean active;
    private float noiseLevel;
    private boolean hasNewData;

    @Override
    public void preProcess(short[] samples, int offset, int length) {
        super.preProcess(samples, offset, length);
        this.hasNewData = true;
    }

    @Override
    public void readStereoOverlay(short[] out, int offset, int length) {
        super.readStereoOverlay(out, offset, length);
        for (int i = 0; i < out.length / 2; ++i) {
            double noise = (Math.random() * 2.0 - 1.0) * (double)this.noiseLevel;
            int index = i * 2;
            out[index] = (short)Math.max(Math.min((double)out[index] + noise, 32767.0), -32768.0);
            out[index + 1] = (short)Math.max(Math.min((double)out[index + 1] + noise, 32767.0), -32768.0);
        }
        this.hasNewData = false;
    }

    @Override
    public boolean canClose() {
        return !this.hasNewData;
    }

    @Override
    public boolean hasStereo() {
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isActive() {
        return this.active && this.noiseLevel > 0.0f;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setNoiseLevel(float noiseLevel) {
        this.noiseLevel = noiseLevel;
    }
}

