/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.channel.channel;

import java.util.Objects;
import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.ui.VoiceChatTextures;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.channel.channel.AbstractChannel;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.voice.protocol.util.properties.ChannelVisibility;

public class CustomChannel
extends AbstractChannel {
    public CustomChannel(UUID id) {
        super(id);
    }

    @Override
    public String getName() {
        return this.properties.getName();
    }

    @Override
    public Icon getIcon() {
        return this.properties.hasPassword() ? VoiceChatTextures.SpriteCommon.CHANNEL_LOCKED : VoiceChatTextures.SpriteCommon.CHANNEL_OPEN;
    }

    @Override
    public Component getIconToolTip() {
        String key = this.properties().hasPassword() ? "locked" : "open";
        return Component.translatable((String)("voicechat.activity.channels.channel." + key), (Component[])new Component[0]);
    }

    @Override
    public boolean hasPermission(ChannelUser user) {
        if (user.isClient()) {
            return this.hasClientPermission();
        }
        return this.isOwner(user);
    }

    @Override
    public boolean hasClientPermission() {
        if (VoiceChatAddon.INSTANCE.client().isStaff()) {
            return true;
        }
        return this.isClientOwner();
    }

    @Override
    public long getCreationTime() {
        return this.properties.getCreationTime();
    }

    @Override
    public boolean isClientOwner() {
        return Objects.equals(this.properties.getOwner(), VoiceChatAddon.getSessionId());
    }

    @Override
    public boolean isVisibleForVisibility(ChannelVisibility filter) {
        if (this.users().isEmpty()) {
            return false;
        }
        return super.isVisibleForVisibility(filter);
    }
}

