/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.commands;

import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.generated.ReferenceStorage;
import net.labymod.addons.voicechat.core.ui.activity.user.VoiceChatUserActivity;
import net.labymod.addons.voicechat.core.util.User;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.util.CollectionHelper;
import net.labymod.api.util.TimeUnit;
import net.labymod.api.util.concurrent.task.Task;
import net.labymod.api.util.io.web.result.ResultCallback;

@Singleton
public class VoiceMuteCommand
extends Command {
    private final VoiceChat voiceChat;
    private final VoiceConnector voiceConnector;

    @Inject
    public VoiceMuteCommand(VoiceChat voiceChat, VoiceConnector voiceConnector) {
        super("voicemute", new String[]{"vm"});
        this.voiceChat = voiceChat;
        this.voiceConnector = voiceConnector;
        this.translationKey("voicechat.commands.mute");
    }

    public boolean execute(String prefix, String[] args) {
        if (!this.voiceConnector.isConnected() || !this.voiceConnector.isAuthenticated()) {
            this.displayTranslatable("notConnected", NamedTextColor.RED, new Component[0]);
            return true;
        }
        if (this.voiceConnector.isStaff()) {
            this.executeAdmin(args);
        } else {
            this.executeUser(args);
        }
        return true;
    }

    private void executeUser(String[] args) {
        if (args.length != 1) {
            this.displaySyntax();
            return;
        }
        User.loadAndBeautify(args[0], (ResultCallback<User>)((ResultCallback)result -> {
            if (!result.isPresent()) {
                this.displayTranslatable("notFound", NamedTextColor.RED, new Object[]{args[0]});
                return;
            }
            User user = (User)result.get();
            Task.builder(() -> this.openActivity((ScreenInstance)new VoiceChatUserActivity(this.voiceChat, user.getUserName(), user.getUniqueId()))).delay(1L, java.util.concurrent.TimeUnit.MILLISECONDS).build().executeOnRenderThread();
        }));
    }

    private void executeAdmin(String[] args) {
        if (args.length == 0 || args.length == 2) {
            this.displaySyntax("admin");
            return;
        }
        if (args.length == 1) {
            this.mutePlayer(args[0]);
            return;
        }
        long duration = TimeUnit.parseToLong((String)args[1]);
        if (duration <= 0L) {
            this.displayTranslatable("admin.invalidDuration", NamedTextColor.RED, new Object[]{args[0], args[1]});
            return;
        }
        Object[] reasonWords = new String[args.length - 2];
        CollectionHelper.copyOfRange((Object[])args, (Object[])reasonWords, (int)2, (int)args.length);
        String reason = String.join((CharSequence)" ", (CharSequence[])reasonWords);
        this.mutePlayer(args[0], duration, reason);
    }

    private void mutePlayer(String userName) {
        this.mutePlayer(userName, 0L, null);
    }

    private void mutePlayer(String userName, long duration, String reason) {
        User.loadAndBeautify(userName, (ResultCallback<User>)((ResultCallback)result -> {
            if (!result.isPresent()) {
                this.displayTranslatable("notFound", NamedTextColor.RED, new Object[]{userName});
                return;
            }
            User user = (User)result.get();
            this.mutePlayer(user.getUserName(), user.getUniqueId(), duration, reason);
        }));
    }

    private void mutePlayer(String userName, UUID uniqueId, long duration, String reason) {
        if (reason == null) {
            ReferenceStorage referenceStorage = this.voiceChat.referenceStorage();
            referenceStorage.voiceConnector().transmitter().requestMetaUpdate(uniqueId);
            Task.builder(() -> this.openActivity((ScreenInstance)new VoiceChatUserActivity(this.voiceChat, userName, uniqueId))).delay(1L, java.util.concurrent.TimeUnit.MILLISECONDS).build().executeOnRenderThread();
            return;
        }
        duration = this.voiceConnector.transmitter().mutePlayer(uniqueId, reason, duration);
        this.displayTranslatable("admin.muted", NamedTextColor.RED, new Object[]{userName, TimeUnit.parseToString((long)duration), reason});
    }
}

