/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.user;

import java.util.UUID;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.configuration.FocusedUsers;
import net.labymod.addons.voicechat.api.event.moderation.VoiceUserMetaEvent;
import net.labymod.addons.voicechat.api.generated.ReferenceStorage;
import net.labymod.addons.voicechat.api.ui.VoiceChatTextures;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.ui.activity.user.widget.ModerationWidget;
import net.labymod.addons.voicechat.core.ui.activity.user.widget.UserSettingsWidget;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.event.Subscribe;
import net.labymod.api.util.ThreadSafe;

@Link(value="voicechat-user.lss")
@AutoActivity
public class VoiceChatUserActivity
extends SimpleActivity {
    private final String username;
    private final UUID uniqueId;
    private final VoiceUser voiceUser;
    private final VoiceChat voiceChat;
    private final VoiceConnector connector;
    private final FocusedUsers focusedUsers;
    private boolean reportingContext;
    private boolean autoFocus;
    private ModerationWidget moderationWidget;
    private IconWidget focusButton;

    public VoiceChatUserActivity(VoiceChat voiceChat, String username, UUID uniqueId) {
        this.username = username;
        this.uniqueId = uniqueId;
        this.voiceChat = voiceChat;
        ReferenceStorage referenceStorage = voiceChat.referenceStorage();
        this.voiceUser = referenceStorage.voiceUserRegistry().getOrCreate(uniqueId);
        this.connector = referenceStorage.voiceConnector();
        this.focusedUsers = referenceStorage.focusedUsers();
        if (this.voiceChat.client().isStaff() && !this.focusedUsers.isPermanentFocused(uniqueId)) {
            this.focusedUsers.focus(this.uniqueId, 3600000L);
        }
        this.autoFocus = this.focusedUsers.isFocused(this.uniqueId) && !this.focusedUsers.isPermanentFocused(this.uniqueId);
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        boolean isStaff = this.connector.isStaff() && (Boolean)this.voiceChat.configuration().modView().get() != false;
        FlexibleContentWidget windowWidget = new FlexibleContentWidget();
        windowWidget.addId(new String[]{"window", isStaff ? "staff-window" : "user-window"});
        HorizontalListWidget profileWrapper = new HorizontalListWidget();
        profileWrapper.addId("header");
        IconWidget headWidget = new IconWidget(Icon.head((UUID)this.uniqueId));
        headWidget.addId("head");
        profileWrapper.addEntry((Widget)headWidget);
        ComponentWidget titleWidget = ComponentWidget.text((String)this.username);
        titleWidget.addId("username");
        profileWrapper.addEntry((Widget)titleWidget);
        if (isStaff) {
            IconWidget warnButton = new IconWidget(VoiceChatTextures.SpriteCommon.WARNING);
            warnButton.addId("warn-button");
            warnButton.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.warn", (Component[])new Component[0]));
            warnButton.setPressable(() -> {
                warnButton.setVisible(false);
                this.labyAPI.minecraft().chatExecutor().chat("/voicewarn " + this.username, false);
            });
            profileWrapper.addEntry((Widget)warnButton);
        }
        this.focusButton = new IconWidget(VoiceChatTextures.SpriteCommon.CROSSHAIR);
        this.focusButton.addId("focus-button");
        this.focusButton.setPressable(() -> {
            this.focusedUsers.toggle(this.uniqueId, this.username);
            this.autoFocus = false;
            this.updateFocusButton();
        });
        profileWrapper.addEntry((Widget)this.focusButton);
        this.updateFocusButton();
        windowWidget.addContent((Widget)profileWrapper);
        HorizontalListWidget contentWrapper = new HorizontalListWidget();
        contentWrapper.addId("content");
        UserSettingsWidget settingsWidget = new UserSettingsWidget(this.voiceChat, this.voiceUser, this.username);
        settingsWidget.setReporting(this.reportingContext);
        settingsWidget.addId("user-content");
        contentWrapper.addEntry((Widget)settingsWidget);
        if (isStaff) {
            this.moderationWidget = new ModerationWidget(this.voiceChat, this.voiceUser, this.username);
            this.moderationWidget.addId("moderation-content");
            contentWrapper.addEntry((Widget)this.moderationWidget);
        }
        windowWidget.addFlexibleContent((Widget)contentWrapper);
        ((Document)this.document).addChild((Widget)windowWidget);
    }

    private void updateFocusButton() {
        if (this.focusedUsers.isFocused(this.uniqueId)) {
            this.focusButton.addId("focused");
            this.focusButton.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.unfocus", (Component[])new Component[0]));
        } else {
            this.focusButton.removeId("focused");
            this.focusButton.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.focus", (Component[])new Component[0]));
        }
    }

    @Subscribe
    public void onVoiceUserMeta(VoiceUserMetaEvent event) {
        if (event.voiceUser() != this.voiceUser) {
            return;
        }
        ThreadSafe.executeOnRenderThread(() -> this.moderationWidget.reInitialize());
    }

    public void onCloseScreen() {
        super.onCloseScreen();
        ((VoiceChatAddon)this.voiceChat).saveConfiguration();
        if (this.autoFocus) {
            this.focusedUsers.unfocus(this.uniqueId);
        }
    }

    public void setReportingContext(boolean reportingContext) {
        this.reportingContext = reportingContext;
    }

    public VoiceUser getVoiceUser() {
        return this.voiceUser;
    }
}

