/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.hudwidget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.UserAudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.player.PlayerAudioStream;
import net.labymod.addons.voicechat.api.audio.util.VisualBuffer;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.channel.util.Identifiable;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.api.configuration.FocusedUsers;
import net.labymod.addons.voicechat.api.generated.ReferenceStorage;
import net.labymod.addons.voicechat.api.ui.VoiceChatTextures;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.stream.user.AbstractAudioStream;
import net.labymod.addons.voicechat.core.channel.channel.LobbyChannel;
import net.labymod.addons.voicechat.core.ui.activity.user.VoiceChatUserActivity;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.SimpleHudWidget;
import net.labymod.api.client.gui.hud.position.HudSize;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.network.ClientPacketListener;
import net.labymod.api.client.network.NetworkPlayerInfo;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.client.scoreboard.ScoreboardTeam;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.mojang.GameProfile;
import net.labymod.api.util.bounds.area.RectangleAreaPosition;
import net.labymod.api.util.time.TimeUtil;
import org.jetbrains.annotations.NotNull;

@SpriteSlot(x=0, y=0)
public class VoiceChatHudWidget
extends SimpleHudWidget<VoiceChatHudWidgetConfig> {
    private static final Collection<AudioStream> DUMMY_STREAMS = new ArrayList<AudioStream>(){
        {
            this.add(new DummyAudioStream("User 1", true));
            this.add(new DummyAudioStream("User 2", false));
            this.add(new DummyAudioStream("User 3", false));
        }
    };
    private static final float USER_HEIGHT = 10.0f;
    private static final float VISUAL_BUFFER_WIDTH = 20.0f;
    private static final float ICON_WIDTH = 8.0f;
    private final AudioStreamRegistry audioStreamRegistry;
    private final VoiceChatAddon voiceChat;
    private final FocusedUsers focusedUsers;
    private final ChannelController channelController;
    private Object lastHoveredUser;

    public VoiceChatHudWidget(VoiceChat voiceChat, AudioStreamRegistry audioStreamRegistry) {
        super("voicechat", VoiceChatHudWidgetConfig.class);
        this.voiceChat = (VoiceChatAddon)voiceChat;
        this.audioStreamRegistry = audioStreamRegistry;
        ReferenceStorage reference = voiceChat.referenceStorage();
        this.focusedUsers = reference.focusedUsers();
        this.channelController = reference.channelController();
    }

    public void initializePreConfigured(VoiceChatHudWidgetConfig config) {
        super.initializePreConfigured((HudWidgetConfig)config);
        config.setEnabled(true);
        config.setX(2.0f);
        config.setY(2.0f);
        config.setAreaIdentifier(RectangleAreaPosition.TOP_LEFT);
        config.setParentToTailOfChainIn(RectangleAreaPosition.TOP_LEFT);
    }

    public void render(SimpleHudWidget.RenderPhase phase, ScreenContext context, boolean isEditorContext, HudSize size) {
        if (this.voiceChat.isTestingMicrophone()) {
            return;
        }
        if (this.channelController.isInCustomChannel()) {
            this.renderChannel(phase, context, isEditorContext, size);
        } else {
            this.renderProximity(phase, context, isEditorContext, size);
        }
    }

    private void renderChannel(SimpleHudWidget.RenderPhase phase, ScreenContext context, boolean isEditorContext, HudSize size) {
        Channel channel = this.channelController.getCurrentChannel();
        if (channel == null || channel instanceof LobbyChannel) {
            return;
        }
        ScreenCanvas canvas = context.canvas();
        VoiceUserRegistry userRegistry = this.voiceChat.referenceStorage().voiceUserRegistry();
        boolean proximity = channel.properties().isProximity();
        Identifiable hovered = null;
        int visibleColor = -1;
        int invisibleColor = 0x50FFFFFF;
        boolean isRightBound = this.anchor.isRight();
        float startX = isRightBound ? size.getActualWidth() : 0.0f;
        float mirror = isRightBound ? -1.0f : 1.0f;
        float x = startX;
        float y = 0.0f;
        size.setWidth(0.0f);
        if (phase.canRender()) {
            float scale = 8.0f;
            canvas.submitIcon(channel.getIcon(), isRightBound ? x - 8.0f : 0.0f, y + 1.0f, scale, scale);
        }
        x += 10.0f * mirror;
        TextComponent channelName = Component.text((String)channel.getName());
        RenderableComponent renderableComponent = RenderableComponent.of((Component)channelName);
        if (phase.canRender()) {
            canvas.submitRenderableComponent(renderableComponent, isRightBound ? x - renderableComponent.getWidth() - 1.0f : x, y + 1.0f, -1, 1);
        }
        x += (renderableComponent.getWidth() + 1.0f) * mirror;
        if (proximity) {
            Icon proximityIcon = VoiceChatTextures.SpriteCommon.CHANNEL_PROXIMITY;
            if (phase.canRender()) {
                float scale = 8.0f;
                canvas.submitIcon(proximityIcon, isRightBound ? x - 8.0f - 2.0f : x + 1.0f, y + 1.0f, scale, scale, false, -1);
            }
            x += 10.0f * mirror;
        }
        size.setWidth(Math.max(size.getActualWidth(), Math.abs(x - startX)));
        y += 11.0f;
        for (ChannelUser user : channel.users().sorted()) {
            boolean hover;
            NetworkPlayerInfo info;
            x = startX + 10.0f * mirror;
            VoiceUser voiceUser = userRegistry.get(user.getId());
            boolean isVisible = !proximity || voiceUser != null && voiceUser.isVisibleInProximity();
            int visibilityColor = isVisible ? visibleColor : invisibleColor;
            ClientPacketListener listener = this.labyAPI.minecraft().getClientPacketListener();
            Icon headIcon = null;
            if (listener != null && (info = listener.getNetworkPlayerInfo(user.getId())) != null) {
                headIcon = Icon.head((GameProfile)info.profile()).hatConsumer(() -> true);
            }
            if (headIcon == null) {
                headIcon = Icon.head((UUID)user.getId());
            }
            if (phase.canRender()) {
                float scale = 8.0f;
                canvas.submitIcon(headIcon, x - (isRightBound ? 8.0f : 0.0f), y + 1.0f, scale, scale, false, visibilityColor);
            }
            x += 9.0f * mirror;
            AudioStreamState voiceState = user.getAudioStreamState(true);
            if (phase.canRender()) {
                float scale = 10.0f;
                canvas.submitIcon(voiceState.getIcon(), x - (isRightBound ? 10.0f : 0.0f), y, scale, scale, this.focusedUsers.isFocused(user.getId()), visibilityColor);
            }
            x += 12.0f * mirror;
            RenderableComponent renderableComponentName = RenderableComponent.of((Component)user.getDisplayName());
            if (phase.canRender()) {
                canvas.submitRenderableComponent(renderableComponentName, x - (isRightBound ? renderableComponentName.getWidth() + 1.0f : 0.0f), y + 1.0f, visibilityColor, 1.0f, 1);
            }
            x += (renderableComponentName.getWidth() + 1.0f) * mirror;
            if (voiceState.isTalking() && ((Boolean)((VoiceChatHudWidgetConfig)this.config).showAudioWaves().get()).booleanValue()) {
                AudioStream stream;
                if (phase.canRender() && (stream = this.audioStreamRegistry.getStream(user.getId())) != null) {
                    stream.visualBuffer().render(context, x - (isRightBound ? 21.0f : 0.0f), y + 5.0f, 20.0f);
                }
                x += 21.0f * mirror;
            }
            size.setWidth(Math.max(size.getActualWidth(), Math.abs(x - startX)));
            MutableMouse mouse = context.mouse();
            boolean bl = hover = mouse != null && mouse.getX() >= 0 && (float)mouse.getX() <= size.getActualWidth() && (float)mouse.getY() >= y && (float)mouse.getY() <= y + 10.0f;
            if (hover && !isEditorContext) {
                hovered = user;
            }
            y += 11.0f;
        }
        if (hovered != null) {
            this.focusedUsers.focus(hovered.getId(), 200L);
        }
        this.lastHoveredUser = hovered;
        size.setHeight(y);
    }

    private void renderProximity(SimpleHudWidget.RenderPhase phase, ScreenContext context, boolean isEditorContext, HudSize size) {
        Collection<AudioStream> streams = this.isVisibleInGame() ? this.audioStreamRegistry.getStreams().values() : DUMMY_STREAMS;
        UserAudioStream hovered = null;
        boolean isRightBound = this.anchor.isRight();
        float startX = isRightBound ? size.getActualWidth() : 0.0f;
        float mirror = isRightBound ? -1.0f : 1.0f;
        size.setWidth(0.0f);
        float y = 0.0f;
        for (AudioStream stream : streams) {
            boolean hover;
            NetworkPlayerInfo info;
            if (!(stream instanceof UserAudioStream)) continue;
            UserAudioStream userStream = (UserAudioStream)stream;
            String name = userStream.getDisplayName();
            UUID uniqueId = userStream.getUserId();
            AudioStreamState voiceState = this.getState(userStream);
            if (((Boolean)((VoiceChatHudWidgetConfig)this.config).hideInactive().get()).booleanValue() && !voiceState.isTalking()) continue;
            Icon indicatorIcon = voiceState.getIcon();
            float x = startX;
            ClientPacketListener listener = this.labyAPI.minecraft().getClientPacketListener();
            Icon headIcon = null;
            if (listener != null && (info = listener.getNetworkPlayerInfo(uniqueId)) != null) {
                headIcon = Icon.head((GameProfile)info.profile()).hatConsumer(() -> true);
            }
            if (headIcon == null) {
                headIcon = Icon.head((UUID)uniqueId);
            }
            ScreenCanvas canvas = context.canvas();
            if (phase.canRender()) {
                float scale = 8.0f;
                canvas.submitIcon(headIcon, x - (isRightBound ? 8.0f : 0.0f), y + 1.0f, scale, scale);
            }
            x += 9.0f * mirror;
            if (phase.canRender()) {
                canvas.submitIcon(indicatorIcon, x - (isRightBound ? 10.0f : 0.0f), y, 10.0f, 10.0f, this.focusedUsers.isFocused(uniqueId), -1);
            }
            x += 12.0f * mirror;
            TextComponent formattedName = Component.text((String)name);
            if (stream instanceof PlayerAudioStream) {
                ScoreboardTeam team;
                Player player;
                NetworkPlayerInfo playerInfo;
                PlayerAudioStream playerStream = (PlayerAudioStream)stream;
                if (((Boolean)((VoiceChatHudWidgetConfig)this.config).coloredNames().get()).booleanValue() && (playerInfo = (player = playerStream.player()).getNetworkPlayerInfo()) != null && (team = playerInfo.getTeam()) != null) {
                    formattedName = team.formatDisplayName((Component)formattedName);
                }
            }
            RenderableComponent renderableComponent = RenderableComponent.of((Component)formattedName);
            if (phase.canRender()) {
                canvas.submitRenderableComponent(renderableComponent, x - (isRightBound ? renderableComponent.getWidth() + 1.0f : 0.0f), y + 1.0f, -1, 1);
            }
            x += (renderableComponent.getWidth() + 1.0f) * mirror;
            if (voiceState.isTalking() && ((Boolean)((VoiceChatHudWidgetConfig)this.config).showAudioWaves().get()).booleanValue()) {
                if (phase.canRender()) {
                    stream.visualBuffer().render(context, x - (isRightBound ? 21.0f : 0.0f), y + 5.0f, 20.0f);
                }
                x += 21.0f * mirror;
            }
            size.setWidth(Math.max(size.getActualWidth(), Math.abs(x - startX)));
            MutableMouse mouse = context.mouse();
            boolean bl = hover = mouse != null && mouse.getX() >= 0 && (float)mouse.getX() <= size.getActualWidth() && (float)mouse.getY() >= y && (float)mouse.getY() <= y + 10.0f;
            if (hover && !isEditorContext) {
                hovered = userStream;
            }
            y += 11.0f;
        }
        if (hovered != null) {
            this.focusedUsers.focus(hovered.getUserId(), 200L);
        }
        this.lastHoveredUser = hovered;
        size.setHeight(y);
    }

    @NotNull
    private AudioStreamState getState(AudioStream stream) {
        if (stream instanceof DummyAudioStream) {
            return stream.isTalking() ? AudioStreamState.TALKING : AudioStreamState.NOT_TALKING;
        }
        return this.audioStreamRegistry.getState(stream.getId(), true);
    }

    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        if (this.lastHoveredUser != null) {
            String name = this.lastHoveredUser instanceof ChannelUser ? ((ChannelUser)this.lastHoveredUser).getName() : ((UserAudioStream)this.lastHoveredUser).getDisplayName();
            UUID uniqueId = this.lastHoveredUser instanceof ChannelUser ? ((ChannelUser)this.lastHoveredUser).getId() : ((UserAudioStream)this.lastHoveredUser).getUserId();
            VoiceChatUserActivity screen = new VoiceChatUserActivity(this.voiceChat, name, uniqueId);
            this.labyAPI.minecraft().minecraftWindow().displayScreen((ScreenInstance)screen);
            this.lastHoveredUser = null;
        }
        return super.mouseClicked(mouse, mouseButton);
    }

    public boolean isVisibleInGame() {
        VoiceConnector client = this.voiceChat.client();
        if (!client.isConnected() || !client.isAuthenticated()) {
            return false;
        }
        return this.channelController.isInCustomChannel() || !this.audioStreamRegistry.getStreams().isEmpty();
    }

    public static class VoiceChatHudWidgetConfig
    extends HudWidgetConfig {
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showAudioWaves = new ConfigProperty((Object)true);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> coloredNames = new ConfigProperty((Object)true);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> hideInactive = new ConfigProperty((Object)false);

        public ConfigProperty<Boolean> showAudioWaves() {
            return this.showAudioWaves;
        }

        public ConfigProperty<Boolean> coloredNames() {
            return this.coloredNames;
        }

        public ConfigProperty<Boolean> hideInactive() {
            return this.hideInactive;
        }
    }

    public static class DummyAudioStream
    extends AbstractAudioStream
    implements UserAudioStream {
        private final UUID uniqueId = new UUID(0L, 0L);
        private final String displayName;
        private final boolean talking;
        private final VisualBuffer visualBuffer;
        private long timeLastVisualWrite;

        public DummyAudioStream(String displayName, boolean talking) {
            super(UUID.randomUUID(), null);
            this.displayName = displayName;
            this.talking = talking;
            this.visualBuffer = new VisualBuffer();
        }

        @Override
        public boolean isTalking() {
            return this.talking;
        }

        @Override
        public VisualBuffer visualBuffer() {
            this.updateDummyNoise();
            return this.visualBuffer;
        }

        private void updateDummyNoise() {
            if (this.timeLastVisualWrite + 10L < TimeUtil.getCurrentTimeMillis()) {
                int tick = (int)(TimeUtil.getCurrentTimeMillis() / 15L % 100000L);
                short[] audio = new short[256];
                for (int i = 0; i < audio.length; i += 2) {
                    double value = Math.sin((float)(tick - i) / 6.0f) / 25.0 + Math.cos((float)(tick - i) / 5.0f) / 35.0;
                    audio[i] = (short)(value * 32767.0);
                }
                this.visualBuffer.write(audio);
                this.timeLastVisualWrite = TimeUtil.getCurrentTimeMillis();
            }
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public UUID getUserId() {
            return this.uniqueId;
        }

        @Override
        @NotNull
        public VoiceUser voiceUser() {
            throw new UnsupportedOperationException();
        }
    }
}

