/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.overlay;

import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.configuration.FocusedUsers;
import net.labymod.api.LabyAPI;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.HorizontalAlignment;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.types.IngameOverlayActivity;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.render.RenderPipeline;
import net.labymod.api.client.render.font.RenderableComponent;

@AutoActivity
public class VoiceFocusOverlay
extends IngameOverlayActivity {
    private static final float CONTENT_TEXT_WIDTH = RenderableComponent.of((Component)Component.translatable((String)"voicechat.overlay.focus.content", (Component[])new Component[0])).getWidth();
    private final VoiceChat voiceChat;
    private final FocusedUsers focusedUsers;
    private final RenderPipeline renderPipeline;

    public VoiceFocusOverlay(VoiceChat voiceChat, FocusedUsers focusedUsers, LabyAPI labyAPI) {
        this.voiceChat = voiceChat;
        this.focusedUsers = focusedUsers;
        this.renderPipeline = labyAPI.renderPipeline();
    }

    public void render(ScreenContext context) {
        super.render(context);
        Bounds bounds = this.labyAPI.minecraft().minecraftWindow().bounds();
        TranslatableComponent focusComponent = Component.translatable((String)"voicechat.overlay.focus.content", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{Component.text((String)String.join((CharSequence)",", this.focusedUsers.getNames()), (TextColor)NamedTextColor.YELLOW)});
        RenderableComponent renderable = RenderableComponent.of((Component)focusComponent, (float)(bounds.getWidth() / 1.2f), (HorizontalAlignment)HorizontalAlignment.CENTER);
        context.canvas().submitRenderableComponent(renderable, bounds.getCenterX(), bounds.getBottom() - 70.0f - renderable.getHeight(), -1, 2);
    }

    public boolean isVisible() {
        return (Boolean)this.voiceChat.configuration().enabled().get() != false && this.focusedUsers.isActive() && !this.focusedUsers.getNames().isEmpty();
    }
}

