/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.tag;

import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.snapshot.VoiceExtraKeys;
import net.labymod.addons.voicechat.api.snapshot.VoiceUserSnapshot;
import net.labymod.api.client.entity.player.tag.tags.IconTag;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import net.labymod.api.reference.annotation.Referenceable;

@Singleton
@Referenceable
public class VoiceTag
extends IconTag {
    private final VoiceChat voiceChat;

    public VoiceTag(VoiceChat voiceChat) {
        super(10.0f);
        this.voiceChat = voiceChat;
    }

    public boolean isVisible() {
        if (!this.snapshot.has(VoiceExtraKeys.VOICE_USER)) {
            return false;
        }
        VoiceUserSnapshot voiceUser = (VoiceUserSnapshot)this.snapshot.get(VoiceExtraKeys.VOICE_USER);
        if (!((Boolean)this.voiceChat.configuration().enabled().get()).booleanValue()) {
            return false;
        }
        if (this.voiceChat.isTestingMicrophone()) {
            return false;
        }
        return voiceUser.isCommunicating() || voiceUser.hasStream();
    }

    public Icon getIcon(EntitySnapshot snapshot) {
        if (!snapshot.has(VoiceExtraKeys.VOICE_USER)) {
            return AudioStreamState.NETWORK_ERROR.getIcon();
        }
        VoiceUserSnapshot userSnapshot = (VoiceUserSnapshot)snapshot.get(VoiceExtraKeys.VOICE_USER);
        return userSnapshot.getStreamState().getIcon();
    }
}

