/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.javaxsound;

import java.util.ArrayList;
import java.util.Collection;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import net.labymod.addons.voicechat.api.audio.device.AbstractAudioInterface;
import net.labymod.addons.voicechat.api.audio.device.Device;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import net.labymod.addons.voicechat.javaxsound.JavaxInputDevice;
import net.labymod.addons.voicechat.javaxsound.JavaxOutputDevice3D;
import net.labymod.addons.voicechat.javaxsound.JavaxUtil;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;

public class JavaxAudioInterface
extends AbstractAudioInterface {
    @Override
    public Component getDisplayName() {
        return Component.text((String)"Java", (TextColor)NamedTextColor.GOLD);
    }

    @Override
    public String getIdentifier() {
        return "javax";
    }

    @Override
    public Device createDevice(DeviceInformation information) {
        return switch (information.getType()) {
            default -> throw new MatchException(null, null);
            case DeviceType.INPUT -> new JavaxInputDevice(information);
            case DeviceType.OUTPUT -> new JavaxOutputDevice3D(information);
        };
    }

    @Override
    protected Collection<DeviceInformation> fetchAvailableDevices(DeviceType type, Format format) {
        Mixer.Info[] mixers;
        AudioFormat audioFormat = JavaxUtil.asAudioFormat(format);
        Class<? extends DataLine> clazz = JavaxUtil.asDataLineClass(type);
        ArrayList<DeviceInformation> list = new ArrayList<DeviceInformation>();
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(clazz, audioFormat))) continue;
            list.add(new DeviceInformation(this, mixerInfo.getName(), mixerInfo.getName(), type, format));
        }
        return list;
    }

    @Override
    public DeviceInformation getDefaultInputDevice(Format format) {
        return this.getDefaultDevice(DeviceType.INPUT, format);
    }

    @Override
    public DeviceInformation getDefaultOutputDevice(Format format) {
        return this.getDefaultDevice(DeviceType.OUTPUT, format);
    }

    public DeviceInformation getDefaultDevice(DeviceType type, Format format) {
        Mixer.Info[] mixers;
        AudioFormat audioFormat = JavaxUtil.asAudioFormat(format);
        Class<? extends DataLine> clazz = JavaxUtil.asDataLineClass(type);
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(clazz, audioFormat))) continue;
            return new DeviceInformation(this, mixerInfo.getName(), mixerInfo.getName(), type, format);
        }
        return null;
    }

    public static <T> T getLineByName(DeviceType type, String name, Format format) throws Exception {
        Mixer.Info[] mixers;
        AudioFormat audioFormat = JavaxUtil.asAudioFormat(format);
        Class<? extends DataLine> clazz = JavaxUtil.asDataLineClass(type);
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(clazz, audioFormat)) || !mixerInfo.getName().equals(name)) continue;
            return (T)mixer.getLine(lineInfo);
        }
        return null;
    }

    public static <T> T getDefaultLine(DeviceType type, Format format) {
        AudioFormat audioFormat = JavaxUtil.asAudioFormat(format);
        Class<? extends DataLine> clazz = JavaxUtil.asDataLineClass(type);
        DataLine.Info info = new DataLine.Info(clazz, audioFormat);
        try {
            return (T)AudioSystem.getLine(info);
        }
        catch (Exception e) {
            return null;
        }
    }
}

