/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.javaxsound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.exception.DeviceException;
import net.labymod.addons.voicechat.api.audio.device.io.AbstractDevice;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import net.labymod.addons.voicechat.javaxsound.JavaxAudioInterface;
import net.labymod.addons.voicechat.javaxsound.JavaxUtil;
import org.jetbrains.annotations.NotNull;

public abstract class JavaxDevice<T extends DataLine>
extends AbstractDevice {
    protected T line;

    public JavaxDevice(@NotNull DeviceInformation information) {
        super(information);
    }

    @Override
    public void open(Format format, int bufferSize) throws DeviceException {
        if (this.isOpen()) {
            throw new DeviceException(this, "Device is already open");
        }
        DeviceType type = this.information.getType();
        String deviceId = this.information.getIdentifier().getDeviceId();
        this.line = this.getLineByIdentifier(type, deviceId, format);
        if (this.line == null) {
            this.logging.error((CharSequence)("Failed to find target device " + String.valueOf(this.information.getIdentifier()) + ", using default"), new Object[0]);
            this.line = this.getDefaultLine(this.information.getType(), format);
        }
        if (this.line == null) {
            throw new DeviceException(this, "Couldn't find any device with the specified format: " + String.valueOf(format));
        }
        try {
            AudioFormat lineFormat = JavaxUtil.asAudioFormat(format);
            this.openx(lineFormat, bufferSize);
        }
        catch (LineUnavailableException e) {
            throw new DeviceException(this, "Failed to open device", e);
        }
        this.line.start();
        this.line.stop();
        this.line.flush();
        super.open(format, bufferSize);
    }

    @Override
    public boolean isOpen() {
        return this.line != null && this.line.isOpen();
    }

    @Override
    public boolean isActive() {
        return this.line != null && this.line.isActive();
    }

    @Override
    public void start() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device is not open");
        }
        this.line.start();
    }

    @Override
    public void stop() {
        if (!this.isOpen()) {
            return;
        }
        this.line.stop();
        this.line.flush();
    }

    @Override
    public void close() {
        if (this.line == null) {
            return;
        }
        this.line.stop();
        this.line.flush();
        this.line.close();
        super.close();
    }

    protected abstract void openx(AudioFormat var1, int var2) throws LineUnavailableException;

    protected T getLineByIdentifier(DeviceType type, String identifier, Format format) throws DeviceException {
        try {
            return (T)((DataLine)JavaxAudioInterface.getLineByName(type, identifier, format));
        }
        catch (Exception e) {
            throw new DeviceException(this, "Failed to get line by identifier", e);
        }
    }

    protected T getDefaultLine(DeviceType type, Format format) {
        return (T)((DataLine)JavaxAudioInterface.getDefaultLine(type, format));
    }
}

